require 'rubygems'
require 'watir-webdriver'
require 'page-object'
require 'rspec'
require_relative 'base/base'
require_relative '../helper/table'

class LandingNotifications < Base
  include PageObject

  def initialize(driver)
    super(driver)
  end

  #Landing Page
  button(:notifications_btn, :css => "#notifications-button")
  h3(:appointments_heading,:css => "#booked")

  #Notifications page
  h2(:header_title, :css=> "#main-content > div > div > div.primary-header.ui-bar.ui-bar-b > h2")
  h2(:appt_page_title, :css=> "#main-content > div div>h2")
  h2(:panel_header_noti_page, :css=> "#main-content > div > div > div.primary-header.ui-bar.ui-bar-b > h2")

  div(:notifications_header, :css => "#notifications-table > div > div:nth-child(2)")
  div(:notification_detail_follow_up_appt, :css=> "#notifications-detail > div.modal-content.ui-body.ui-body-b.ui-corner-all.ui-shadow")
  div(:notification_details_action, :css => "#notifications-detail > div.notification-detail-actions")
  div(:status_col, :css=> "#notifications-table > div.table-list-head.ui-bar.ui-bar-b.ui-btn-icon-right > div:nth-child(1)")
  div(:notification_col, :css=> "#notifications-table > div.table-list-head.ui-bar.ui-bar-b.ui-btn-icon-right > div:nth-child(2)")
  div(:source_col, :css=> "#notifications-table > div.table-list-head.ui-bar.ui-bar-b.ui-btn-icon-right > div:nth-child(3)")
  div(:request_list, :css => "#requested-appointments-table-list > div")

  button(:notification_detail_new_appt, :css => "#heading-new-appointment-request-btn")
  button(:return_to_note_list_btn, :id=> 'cancel-btn')
  button(:appointment_btn, :id => "back-btn")
  button(:delete_btn, :id => 'delete-btn')
  button(:delete_modal_no_btn, :css => "#notification-cancellation-return-btn")
  button(:delete_modal_yes_btn, :css => "#notification-cancellation-continue-btn")
  button(:notification, :css=> "#notifications-list > li > button")
  elements(:notifications_list, :button, :css=>"#notifications-list > li > button")

  p(:no_notifications, :css => "#main-content > div > div > div.notifications-layout-section > div > p")
  p(:delete_modal_body, :css => "#notification-cancellation > div.ui-content > p")

  span(:notification_col_title,:css=> "#notifications-list > li:nth-child(1) > button > div > span:nth-child(3) > span.list-cell-data-item")
  span(:source_col_title,:css=> "#notifications-list > li:nth-child(1) > button > div > span:nth-child(4) > span.list-cell-data > span")
  span(:notifications_subject, :css => "#notifications-list > li:nth-child(1) > button > div > span:nth-child(4) > span.list-cell-data > span")
  span(:read_unread_indicator, :css => "#notifications-list > li:nth-child(1) > button > div > span.list-cell-icon > span.list-cell-data-item > span")
  span(:notifications_counter,:css=> "#notifications-button > span.badge")

  ordered_list(:request_list_items, :css => "#requested-appointments-table-list > ol")

  div(:select_appointment, :xpath => "//*[contains(text(),'Appointments/Requests')]")

  def clickReturnToNotificationList
    wait_until{ !return_to_note_list_btn_element.attribute('disabled') }
    return_to_note_list_btn_element.when_present(TIME_OUT_LIMIT)
    return_to_note_list_btn
  end

  def clickNotificationsButton
    wait_until{ !notifications_btn_element.attribute('disabled') }
    notifications_btn_element.when_present(TIME_OUT_LIMIT)
    notifications_btn
  end

  def clickBackButton
    wait_until{ !appointment_btn_element.attribute('disabled') }
    appointment_btn_element.when_present(TIME_OUT_LIMIT)
    appointment_btn
  end

end